in vec3 vPos;
in vec3 vNormal;
uniform vec3 lightPos;
uniform vec3 baseColor;
out vec4 FragColor;

uniform vec3 cameraPos;
uniform vec3 fogColor;
uniform float fogStart;
uniform float fogEnd;

void main() {
    vec3 normal = normalize(vNormal);
    vec3 lightDir = normalize(lightPos - vPos);
    float diff = max(dot(normal, lightDir), 0.0);

    vec3 ambient = 0.2 * baseColor;
    vec3 diffuse = baseColor * diff;
    float dist = length(vPos - cameraPos);

    float fogFactor;
    vec3 litColor = ambient + diffuse;


    float density = 0.015;
    fogFactor = 1.0 - exp(-density * dist);

    fogFactor = clamp(fogFactor + 0.08, 0.0, 1.0);
    fogFactor = fogFactor * fogFactor;
    vec3 finalColor = mix(litColor, fogColor, fogFactor);

    FragColor = vec4(finalColor, 1.0);

    

}